local vs_source = [[
    precision highp float;

    uniform mat4 modelViewProjection;
    
    attribute vec4 position;
    attribute vec4 color;

    varying lowp vec4 vColor;
    
    void main()
    {
        gl_Position = modelViewProjection * position;
        vColor = color;
    }
]]

local fs_source = [[
    precision highp float;

    varying lowp vec4 vColor;
    
    void main()
    {
        gl_FragColor = vColor;
    }
]]

function GrassShader()
    return shader(vs_source, fs_source)
end